/*

Macro_Scripts File
Purposes:  
    
	define action for each modifier to hook up to the create main menu (or quads)
	
	Requires AddmodFunc.ms

Revision History
	13 November 2008, Bernard Lefebvre
		Adding Quadify Mesh & Welder Modifiers
		
	10 June 2008, Bernard Lefebvre
		Adding ProOptimizer Modifier
		
	9 June 2005, Pierre-Felix Breton
		Adding Hair modifiers
		
	18 May 2005, Pierre-Felix Breton
		Adding Cloth modifiers

	16 fev 2004, Pierre-Felix Breton
		adding UVW Unwrap back
		adding Renderable Spline Modifier

	15 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


	26 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6
	
	April 22 2002: Fred Ruff
		created for 3ds MAX 5
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK




macroScript Bend
            category:~BEND_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~BEND_BUTTONTEXT~
			tooltip:~BEND_TOOLTIP~ 
            Icon:#("Standard_Modifiers",1)
(
	on execute do AddMod Bend
	on isEnabled return mcrUtils.ValidMod Bend
)

macroScript Taper 
            category:~TAPER_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~TAPER_BUTTONTEXT~
            tooltip:~TAPER_TOOLTIP~ 
            Icon:#("Standard_Modifiers",2)
(
	on execute do AddMod Taper
	on isEnabled return mcrUtils.ValidMod Taper
)

macroScript MeshSmooth 
            category:~MESHSMOOTH_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~MESHSMOOTH_BUTTONTEXT~
            tooltip:~MESHSMOOTH_TOOLTIP~ 
            Icon:#("Standard_Modifiers",19)
(
	on execute do AddMod MeshSmooth
	on isEnabled return mcrUtils.ValidMod MeshSmooth
)

macroScript Ripple 
            category:~RIPPLE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~RIPPLE_BUTTONTEXT~
            tooltip:~RIPPLE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",9)
(
	on execute do AddMod Ripple
	on isEnabled return mcrUtils.ValidMod Ripple
)

macroScript Wave 
            category:~WAVE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~WAVE_BUTTONTEXT~
            tooltip:~WAVE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",8)
(
	on execute do AddMod Wave
	on isEnabled return mcrUtils.ValidMod Wave
)

macroScript Edit_Mesh 
            category:~EDIT_MESH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~EDIT_MESH_TOOLTIP~
			ButtonText:~EDIT_MESH_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",1)
(
	on execute do AddMod Edit_Mesh
	on isEnabled return mcrUtils.ValidMod Edit_Mesh
)

macroScript Edit_Spline
            category:~EDIT_SPLINE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~EDIT_SPLINE_TOOLTIP~
			ButtonText:~EDIT_SPLINE_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",11)
(
	on execute do AddMod Edit_Spline
	on isEnabled return mcrUtils.ValidMod Edit_Spline
)

macroScript Relax 
            category:~RELAX_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~RELAX_BUTTONTEXT~
            tooltip:~RELAX_TOOLTIP~ 
            Icon:#("Standard_Modifiers",21)
(
	on execute do AddMod Relax
	on isEnabled return mcrUtils.ValidMod Relax
)

macroScript Edit_Patch 
            category:~EDIT_PATCH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~EDIT_PATCH_TOOLTIP~
			ButtonText:~EDIT_PATCH_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",2)
(
	on execute do AddMod Edit_Patch
	on isEnabled return mcrUtils.ValidMod Edit_Patch
)

macroScript Twist 
            category:~TWIST_CATEGORY~
            internalCategory:"Modifiers"
			ButtonText:~TWIST_BUTTONTEXT~ 
            tooltip:~TWIST_TOOLTIP~ 
            Icon:#("Standard_Modifiers",4)
(
	on execute do AddMod Twist
	on isEnabled return mcrUtils.ValidMod Twist
)

macroScript Extrude 
            category:~EXTRUDE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~EXTRUDE_BUTTONTEXT~
            tooltip:~EXTRUDE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",13)
(
	on execute do AddMod Extrude
	on isEnabled return mcrUtils.ValidMod Extrude
)

macroScript Lathe 
            category:~LATHE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~LATHE_BUTTONTEXT~
            tooltip:~LATHE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",14)
(
	on execute do AddMod Lathe
	on isEnabled return mcrUtils.ValidMod Lathe
)

macroScript Bevel 
            category:~BEVEL_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~BEVEL_BUTTONTEXT~
            tooltip:~BEVEL_TOOLTIP~ 
            Icon:#("Standard_Modifiers",17)
(
	on execute do AddMod Bevel
	on isEnabled return mcrUtils.ValidMod Bevel
)

macroScript Stretch 
            category:~STRETCH_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~STRETCH_BUTTONTEXT~
            tooltip:~STRETCH_TOOLTIP~ 
            Icon:#("Standard_Modifiers",5)
(
	on execute do AddMod Stretch
	on isEnabled return mcrUtils.ValidMod Stretch
)

macroScript Face_Extrude 
            category:~FACE_EXTRUDE_CATEGORY~
            internalCategory:"Modifiers" 
            tooltip:~FACE_EXTRUDE_TOOLTIP~
			ButtonText:~FACE_EXTRUDE_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",5)
(
	on execute do AddMod Face_Extrude
	on isEnabled return mcrUtils.ValidMod Face_Extrude
)

macroScript Optimize 
            category:~OPTIMIZE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~OPTIMIZE_BUTTONTEXT~
            tooltip:~OPTIMIZE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",34)
(
	on execute do AddMod Optimize
	on isEnabled return mcrUtils.ValidMod Optimize
)

macroScript Displace 
            category:~DISPLACE_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~DISPLACE_BUTTONTEXT~
            tooltip:~DISPLACE_TOOLTIP~ 
            Icon:#("Standard_Modifiers",18)
(
	on execute do AddMod Displace
	on isEnabled return mcrUtils.ValidMod Displace
)

macroScript Linked_xform 
            category:~LINKED_XFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~LINKED_XFORM_TOOLTIP~
			ButtonText:~LINKED_XFORM_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",32)
(
	on execute do AddMod Linked_xform
	on isEnabled return mcrUtils.ValidMod Linked_xform
)

macroScript Affect_Region 
            category:~AFFECT_REGION_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~AFFECT_REGION_TOOLTIP~
			ButtonText:~AFFECT_REGION_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",15)
(
	on execute do AddMod Affect_Region
	on isEnabled return mcrUtils.ValidMod Affect_Region
)

macroScript Uvwmap 
            category:~UVWMAP_CATEGORY~
            internalCategory:"Modifiers" 
            tooltip:~UVWMAP_TOOLTIP~
			ButtonText:~UVWMAP_BUTTONTEXT~ 
            Icon:#("Material_Modifiers",4)
(
	on execute do AddMod Uvwmap
	on isEnabled return mcrUtils.ValidMod Uvwmap
)

macroScript Volumeselect 
            category:~VOLUMESELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~VOLUMESELECT_TOOLTIP~ 
			ButtonText:~VOLUMESELECT_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",4)
(
	on execute do AddMod VolumeSelect
	on isEnabled return mcrUtils.ValidMod VolumeSelect
)

macroScript Material_ID 
            category:~MATERIAL_ID_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MATERIAL_ID_TOOLTIP~
			ButtonText:~MATERIAL_ID_BUTTONTEXT~ 
            Icon:#("Material_Modifiers",2)
(
	on execute do AddMod Materialmodifier
	on isEnabled return mcrUtils.ValidMod Materialmodifier
)

macroScript Smooth 
            category:~SMOOTH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SMOOTH_TOOLTIP~
			ButtonText:~SMOOTH_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",23)
(
	on execute do AddMod smooth
	on isEnabled return mcrUtils.ValidMod smooth
)

macroScript Normalmodifier 
            category:~NORMALMODIFIER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~NORMALMODIFIER_TOOLTIP~ 
			ButtonText:~NORMALMODIFIER_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",6)
(
	on execute do AddMod Normalmodifier
	on isEnabled return mcrUtils.ValidMod Normalmodifier
)

macroScript Skin 
            category:~SKIN_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SKIN_TOOLTIP~ 
			ButtonText:~SKIN_BUTTONTEXT~
            Icon:#("Standard_Modifiers",26)
(
	on execute do AddMod Skin
	on isEnabled return mcrUtils.ValidMod Skin
)

macroScript Unwrap_UVW 
            category:~UNWRAP_UVW_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~UNWRAP_UVW_TOOLTIP~ 
			ButtonText:~UNWRAP_UVW_BUTTONTEXT~
            Icon:#("Material_Modifiers",6)
(
	on execute do AddMod Unwrap_UVW
	on isEnabled return mcrUtils.ValidMod Unwrap_UVW
)

macroScript Push 
            category:~PUSH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~PUSH_TOOLTIP~
			ButtonText:~PUSH_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",36)
(
	on execute do AddMod Push
	on isEnabled return mcrUtils.ValidMod Push
)

macroScript Trim_Extend 
            category:~TRIM_EXTEND_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~TRIM_EXTEND_TOOLTIP~
			ButtonText:~TRIM_EXTEND_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",14)
(
	on execute do AddMod Trim_Extend
	on isEnabled return mcrUtils.ValidMod Trim_Extend
)

macroScript Squeeze 
            category:~SQUEEZE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SQUEEZE_TOOLTIP~
			ButtonText:~SQUEEZE_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",6)
(
	on execute do AddMod Squeeze
	on isEnabled return mcrUtils.ValidMod Squeeze
)

macroScript Delete_Spline 
            category:~DELETE_SPLINE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~DELETE_SPLINE_TOOLTIP~
			ButtonText:~DELETE_SPLINE_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",12)
(
	on execute do AddMod DeleteSplineModifier
	on isEnabled return mcrUtils.ValidMod DeleteSplineModifier
)

macroScript CrossSection 
            category:~CROSSSECTION_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~CROSSSECTION_TOOLTIP~
			ButtonText:~CROSSSECTION_BUTTONTEXT~ 
            Icon:#("Surface_Tools",1)
(
	on execute do AddMod CrossSection
	on isEnabled return mcrUtils.ValidMod CrossSection
)

macroScript Surface 
            category:~SURFACE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SURFACE_TOOLTIP~
			ButtonText:~SURFACE_BUTTONTEXT~ 
            Icon:#("Surface_Tools",2)
(
	on execute do AddMod surface
	on isEnabled return mcrUtils.ValidMod surface
)

macroScript Lattice 
            category:~LATTICE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~LATTICE_TOOLTIP~
			ButtonText:~LATTICE_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",8)
(
	on execute do AddMod Lattice
	on isEnabled return mcrUtils.ValidMod Lattice
)

macroScript Fillet_Chamfer 
            category:~FILLET_CHAMFER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FILLET_CHAMFER_TOOLTIP~
			ButtonText:~FILLET_CHAMFER_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",13)
(
	on execute do AddMod Fillet_Chamfer
	on isEnabled return mcrUtils.ValidMod Fillet_Chamfer
)

macroScript Morpher 
            category:~MORPHER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MORPHER_TOOLTIP~
			ButtonText:~MORPHER_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",24)
(
	on execute do AddMod Morpher
	on isEnabled return mcrUtils.ValidMod Morpher
)

macroScript Normalize_Spline 
            category:~NORMALIZE_SPLINE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~NORMALIZE_SPLINE_TOOLTIP~
			ButtonText:~NORMALIZE_SPLINE_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",13)
(
	on execute do AddMod Normalize_Spline
	on isEnabled return mcrUtils.ValidMod Normalize_Spline
)

macroScript FFD_2x2x2 
            category:~FFD_2X2X2_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFD_2X2X2_TOOLTIP~ 
			ButtonText:"FFD 2x2x2"
            Icon:#("Standard_Modifiers",10)
(
	on execute do AddMod FFD_2x2x2
	on isEnabled return mcrUtils.ValidMod FFD_2x2x2
)

macroScript FFD_4x4x4 
            category:~FFD_4X4X4_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFD_4X4X4_TOOLTIP~
			ButtonText:"FFD 4x4x4" 
            Icon:#("Standard_Modifiers",10)
(
	on execute do AddMod FFD_4x4x4
	on isEnabled return mcrUtils.ValidMod FFD_4x4x4
)

macroScript FFD_3x3x3 
            category:~FFD_3X3X3_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFD_3X3X3_TOOLTIP~
			ButtonText:"FFD 3x3x3" 
            Icon:#("Standard_Modifiers",10)
(
	on execute do AddMod FFD_3x3x3
	on isEnabled return mcrUtils.ValidMod FFD_3x3x3
)

macroScript CameraMap 
            category:~CAMERAMAP_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~CAMERAMAP_TOOLTIP~
			ButtonText:~CAMERAMAP_BUTTONTEXT~ 
            Icon:#("Deform_Modifiers",1)
(
	on execute do AddMod CameraMap
	on isEnabled return mcrUtils.ValidMod CameraMap
)


macroScript XForm 
            category:~XFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~XFORM_TOOLTIP~
			ButtonText:~XFORM_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",31)
(
	on execute do AddMod XForm
	on isEnabled return mcrUtils.ValidMod XForm
)

macroScript Slice 
            category:~SLICE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SLICE_TOOLTIP~
			ButtonText:~SLICE_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",30)
(
	on execute do AddMod slicemodifier
	on isEnabled return mcrUtils.ValidMod slicemodifier
)

macroScript FFD_Select 
            category:~FFD_SELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFD_SELECT_TOOLTIP~
			ButtonText:~FFD_SELECT_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",12)
(
	on execute do AddMod FFD_Select
	on isEnabled return mcrUtils.ValidMod FFD_Select
)

macroScript Melt 
            category:~MELT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MELT_TOOLTIP~
			ButtonText:~MELT_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",20)
(
	on execute do 
	(	try (AddMod Melt) Catch(MessageBox ~MELT_NOT_INSTALLED_CAPTION~ Title:~MELT_NOT_INSTALLED_TITLE~)
	)
	on isEnabled return mcrUtils.ValidMod Melt
)

macroScript STL_Check 
            category:~STL_CHECK_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~STL_CHECK_TOOLTIP~
			ButtonText:~STL_CHECK_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",33)
(
	on execute do AddMod STL_Check
	on isEnabled return mcrUtils.ValidMod STL_Check
)

macroScript Cap_Holes 
            category:~CAP_HOLES_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~CAP_HOLES_TOOLTIP~
			ButtonText:~CAP_HOLES_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",29)
(
	on execute do AddMod Cap_Holes
	on isEnabled return mcrUtils.ValidMod Cap_Holes
)

macroScript Preserve 
            category:~PRESERVE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~PRESERVE_TOOLTIP~
			ButtonText:~PRESERVE_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",35)
(
	on execute do AddMod Preserve
	on isEnabled return mcrUtils.ValidMod Preserve
)

macroScript Spline_Select 
            category:~SPLINE_SELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SPLINE_SELECT_TOOLTIP~ 
			ButtonText:~SPLINE_SELECT_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",10)
(
	on execute do AddMod SplineSelect
	on isEnabled return mcrUtils.ValidMod SplineSelect
)

macroScript Material_By_Element 
            category:~MATERIAL_BY_ELEMENT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MATERIAL_BY_ELEMENT_TOOLTIP~
			ButtonText:~MATERIAL_BY_ELEMENT_BUTTONTEXT~ 
            Icon:#("Material_Modifiers",3)
(
	on execute do AddMod MaterialByElement
	on isEnabled return mcrUtils.ValidMod MaterialByElement
)

macroScript UVW_Xform 
            category:~UVW_XFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~UVW_XFORM_TOOLTIP~
			ButtonText:~UVW_XFORM_BUTTONTEXT~
            Icon:#("Material_Modifiers",5)
(
	on execute do AddMod UVW_Xform
	on isEnabled return mcrUtils.ValidMod UVW_Xform
)



macroScript PatchDeform 
            category:~PATCHDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~PATCHDEFORM_TOOLTIP~
			ButtonText:~PATCHDEFORM_BUTTONTEXT~ 
            Icon:#("Deform_Modifiers",3)
(
	on execute do AddMod PatchDeform
	on isEnabled return mcrUtils.ValidMod PatchDeform
)

macroScript WPatchDeform 
            category:~WPATCHDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WPATCHDEFORM_TOOLTIP~
			ButtonText:~WPATCHDEFORM_BUTTONTEXT~ 
            Icon:#("Deform_Modifiers",3)
(
	on execute do AddMod SpacePatchDeform
	on isEnabled return mcrUtils.ValidMod SpacePatchDeform
)

macroScript NSurf_Sel 
            category:~NSURF_SEL_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~NSURF_SEL_TOOLTIP~
			ButtonText:~NSURF_SEL_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",16)
(
	on execute do AddMod NSurf_Sel
	on isEnabled return mcrUtils.ValidMod NSurf_Sel
)

macroScript Vertex_Paint 
            category:~VERTEX_PAINT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~VERTEX_PAINT_TOOLTIP~
			ButtonText:~VERTEX_PAINT_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",37)
( 
	on execute do
	(	
		AddMod VertexPaint
	/* -- 29 mai 2003; pfb:  commented out fancy triggering because inconsistant with the way the create panel works and may ruin layers connection
		if ((AddMod VertexPaint) == true) then  -- it worked, do so logical presets
		(
			for i = 1 to selection.count do
			(
				selection[i].showvertexcolors = true
				selection[i].vertexcolorsshaded = true
				selection[i].wirecolor = white
			)
		)
		-- else do nothing
	*/
	)

	on isEnabled return mcrUtils.ValidMod VertexPaint
)


macroScript Skew 
            category:~SKEW_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SKEW_TOOLTIP~
			ButtonText:~SKEW_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",3)
(
	on execute do AddMod Skew
	on isEnabled return mcrUtils.ValidMod Skew
)

macroScript Mesh_Select
            category:~MESH_SELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MESH_SELECT_TOOLTIP~
			ButtonText:~MESH_SELECT_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",3)
(
	on execute do AddMod Mesh_Select
	on isEnabled return mcrUtils.ValidMod Mesh_Select
)

macroScript SurfDeform 
            category:~SURFDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SURFDEFORM_TOOLTIP~ 
			ButtonText:~SURFDEFORM_BUTTONTEXT~
            Icon:#("Deform_Modifiers",5)
(
	on execute do AddMod SurfDeform
	on isEnabled return mcrUtils.ValidMod SurfDeform
)


macroScript Disp_Approx 
            category:~DISP_APPROX_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~DISP_APPROX_TOOLTIP~
			ButtonText:~DISP_APPROX_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",18)
(
	on execute do AddMod Disp_Approx
	on isEnabled return mcrUtils.ValidMod Disp_Approx
)

macroScript Bevel_Profile 
            category:~BEVEL_PROFILE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~BEVEL_PROFILE_TOOLTIP~
			ButtonText:~BEVEL_PROFILE_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",16)
(
	on execute do AddMod Bevel_Profile
	on isEnabled return mcrUtils.ValidMod Bevel_Profile
)

macroScript PathDeform 
            category:~PATHDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~PATHDEFORM_TOOLTIP~ 
			ButtonText:~PATHDEFORM_BUTTONTEXT~
            Icon:#("Deform_Modifiers",7) 
(
	on execute do AddMod PathDeform
	on isEnabled return mcrUtils.ValidMod PathDeform
)

macroScript WPathDeform 
            category:~WPATHDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WPATHDEFORM_TOOLTIP~ 
			ButtonText:~WPATHDEFORM_BUTTONTEXT~
            Icon:#("Deform_Modifiers",7) 
(
	on execute do AddMod SpacePathDeform
	on isEnabled return mcrUtils.ValidMod SpacePathDeform
)

macroScript FFDBox 
            category:~FFDBOX_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFDBOX_TOOLTIP~
			ButtonText:~FFDBOX_BUTTONTEXT~
            Icon:#("Standard_Modifiers",10)
(
	on execute do AddMod FFDBox
	on isEnabled return mcrUtils.ValidMod FFDBox
)

macroScript FFDCyl 
            category:~FFDCYL_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FFDCYL_TOOLTIP~ 
			ButtonText:~FFDCYL_BUTTONTEXT~
            Icon:#("Standard_Modifiers",11)
(
	on execute do AddMod FFDCyl
	on isEnabled return mcrUtils.ValidMod FFDCyl
)

macroScript Tessellate 
            category:~TESSELLATE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~TESSELLATE_TOOLTIP~
			ButtonText:~TESSELLATE_BUTTONTEXT~ 
            Icon:#("Max_Edit_Modifiers",7)
(
	on execute do AddMod Tessellate
	on isEnabled return mcrUtils.ValidMod Tessellate
)

macroScript Spherify 
            category:~SPHERIFY_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SPHERIFY_TOOLTIP~
			ButtonText:~SPHERIFY_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",22)
(
	on execute do AddMod Spherify
	on isEnabled return mcrUtils.ValidMod Spherify
)

macroScript Flex 
            category:~FLEX_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~FLEX_TOOLTIP~
			ButtonText:~FLEX_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",27)
(
	on execute do AddMod Flex
	on isEnabled return mcrUtils.ValidMod Flex
)

macroScript Mirror 
            category:~MIRROR_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MIRROR_TOOLTIP~
			ButtonText:~MIRROR_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",28)
(
	on execute do AddMod Mirror
	on isEnabled return mcrUtils.ValidMod Mirror
)

macroScript DeleteMesh 
            category:~DELETEMESH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~DELETEMESH_TOOLTIP~
			ButtonText:~DELETEMESH_BUTTONTEXT~
            Icon:#("Max_Edit_Modifiers",9)
(
	on execute do AddMod DeleteMesh
	on isEnabled return mcrUtils.ValidMod DeleteMesh
)

macroScript MultiRes 
            category:~MULTIRES_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MULTIRES_TOOLTIP~
			ButtonText:~MULTIRES_BUTTONTEXT~
(
	on execute do AddMod MultiRes
	on isEnabled return mcrUtils.ValidMod MultiRes
)

macroScript Noise 
            category:~NOISE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~NOISE_TOOLTIP~
			ButtonText:~NOISE_BUTTONTEXT~ 
            Icon:#("Standard_Modifiers",7)
(
	on execute do AddMod Noisemodifier
	on isEnabled return mcrUtils.ValidMod Noisemodifier
)

-- Added new r4 modifiers 
--***********************************************************************************************

macroScript DeletePatch 
            category:~DELETEPATCH_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~DELETEPATCH_TOOLTIP~ 
			ButtonText:~DELETEPATCH_BUTTONTEXT~
(
	on execute do AddMod DeletePatch
	on isEnabled return mcrUtils.ValidMod DeletePatch
)
macroScript PatchSelect 
            category:~PATCHSELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~PATCHSELECT_TOOLTIP~ 
			ButtonText:~PATCHSELECT_BUTTONTEXT~ 
(
	on execute do AddMod Patch_Select
	on isEnabled return mcrUtils.ValidMod Patch_Select
)
macroScript PointCache 
            category:~POINTCACHE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~POINTCACHE_TOOLTIP~ 
			ButtonText:~POINTCACHE_BUTTONTEXT~
(
	on execute do AddMod Point_Cache
	on isEnabled return mcrUtils.ValidMod Point_Cache
)

macroScript WPointCache 
            category:~WPOINTCACHE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WPOINTCACHE_TOOLTIP~ 
			ButtonText:~WPOINTCACHE_BUTTONTEXT~
(
	on execute do AddMod Point_CacheSpacewarpModifier
	on isEnabled return mcrUtils.ValidMod Point_CacheSpacewarpModifier
)

macroScript HSDSModifier 
            category:~HSDSMODIFIER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~HSDSMODIFIER_TOOLTIP~ 
			ButtonText:~HSDSMODIFIER_BUTTONTEXT~
(
	on execute do AddMod HSDS_Modifier
	on isEnabled return mcrUtils.ValidMod HSDS_Modifier
)
macroScript ConvertToPatch 
           category:~CONVERTTOPATCH_CATEGORY~ 
           internalCategory:"Modifiers" 
            tooltip:~CONVERTTOPATCH_TOOLTIP~ 
			ButtonText:~CONVERTTOPATCH_BUTTONTEXT~
(
	on execute do AddMod ConvertToPatch
	on isEnabled return mcrUtils.ValidMod ConvertToPatch
)
macroScript SpaceCameraMap 
            category:~SPACECAMERAMAP_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SPACECAMERAMAP_TOOLTIP~
			ButtonText:~SPACECAMERAMAP_BUTTONTEXT~ 
            Icon:#("Deform_Modifiers",1)
(
	on execute do addModifier $ (SpaceCameraMap ())
	on isEnabled return mcrUtils.ValidMod SpaceCameraMap 
)
macroScript SpaceSurfDeform 
            category:~SPACESURFDEFORM_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SPACESURFDEFORM_TOOLTIP~ 
			ButtonText:~SPACESURFDEFORM_BUTTONTEXT~
            Icon:#("Deform_Modifiers",5)
(
	on execute do addModifier $ (SpaceSurfDeform ())
	on isEnabled return mcrUtils.ValidMod SpaceSurfDeform 
)

macroScript PolySelect 
            category:~POLYSELECT_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~POLYSELECT_TOOLTIP~ 
			ButtonText:~POLYSELECT_BUTTONTEXT~ 
(
	on execute do AddMod Poly_Select
	on isEnabled return mcrUtils.ValidMod Poly_Select
)
--***********************************************************************************************
-- added max 5 modifiers

macroScript Subdivide 
            category:~SUBDIVIDE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SUBDIVIDE_TOOLTIP~ 
			ButtonText:~SUBDIVIDE_BUTTONTEXT~ 
(
	on execute do AddMod Subdivide 
	on isEnabled return mcrUtils.ValidMod Subdivide 
)

macroScript WSubdivide 
            category:~WSUBDIVIDE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WSUBDIVIDE_TOOLTIP~ 
			ButtonText:~WSUBDIVIDE_BUTTONTEXT~ 
(
	on execute do AddMod subdivideSpacewarpModifier 
	on isEnabled return mcrUtils.ValidMod subdivideSpacewarpModifier 
)
macroScript EditNormals 
            category:~EDITNORMALS_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~EDITNORMALS_TOOLTIP~ 
			ButtonText:~EDITNORMALS_BUTTONTEXT~ 
(
	on execute do AddMod EditNormals 
	on isEnabled return mcrUtils.ValidMod EditNormals 
)
macroScript Symmetry 
            category:~SYMMETRY_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SYMMETRY_TOOLTIP~ 
			ButtonText:~SYMMETRY_BUTTONTEXT~ 
(
	on execute do AddMod Symmetry
	on isEnabled return mcrUtils.ValidMod Symmetry
)
macroScript VertexWeld 
            category:~VERTEXWELD_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~VERTEXWELD_TOOLTIP~ 
			ButtonText:~VERTEXWELD_BUTTONTEXT~ 
(
	on execute do AddMod Vertex_Weld 
	on isEnabled return mcrUtils.ValidMod Vertex_Weld 
)
macroScript SplineIkControl 
            category:~SPLINEIKCONTROL_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SPLINEIKCONTROL_TOOLTIP~ 
			ButtonText:~SPLINEIKCONTROL_BUTTONTEXT~ 
(
	on execute do AddMod Spline_Ik_Control 
	on isEnabled return mcrUtils.ValidMod Spline_Ik_Control 
)

--***********************************************************************************************
-- added during MAX max 6 cycle
macroScript SelectByChannel 
            category:~SELECTBYCHANNEL_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SELECTBYCHANNEL_TOOLTIP~ 
			ButtonText:~SELECTBYCHANNEL_BUTTONTEXT~ 
(
	on execute do AddMod Select_By_Channel 
	on isEnabled return mcrUtils.ValidMod Select_By_Channel 
)

macroScript Shell 
            category:~SHELL_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~SHELL_TOOLTIP~ 
			ButtonText:~SHELL_BUTTONTEXT~ 
(
	on execute do AddMod Shell 
	on isEnabled return mcrUtils.ValidMod Shell 
)
macroScript WDispApprox
            category:~WDISPAPPROX_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WDISPAPPROX_TOOLTIP~ 
			ButtonText:~WDISPAPPROX_BUTTONTEXT~ 
(
	on execute do AddMod Displace_Mesh
	on isEnabled return mcrUtils.ValidMod Displace_Mesh
)

macroScript TurnToPolyMod 
            category:~TURNTOPOLYMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~TURNTOPOLYMOD_TOOLTIP~ 
			ButtonText:~TURNTOPOLYMOD_BUTTONTEXT~ 
(
	on execute do AddMod Turn_To_Poly
	on isEnabled return mcrUtils.ValidMod Turn_To_Poly

)

macroScript TurnToPatchMod 
            category:~TURNTOPATCHMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~TURNTOPATCHMOD_TOOLTIP~ 
			ButtonText:~TURNTOPATCHMOD_BUTTONTEXT~ 
(
	on execute do AddMod Turn_To_Patch 
	on isEnabled return mcrUtils.ValidMod Turn_To_Patch 

)

macroScript TurnToMeshMod 
            category:~TURNTOMESHMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~TURNTOMESHMOD_TOOLTIP~ 
			ButtonText:~TURNTOMESHMOD_BUTTONTEXT~ 
(
	on execute do AddMod Turn_To_Mesh
	on isEnabled return mcrUtils.ValidMod Turn_To_Mesh

)

macroScript UvwmapAdd 
            category:~UVWMAPADD_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~UVWMAPADD_TOOLTIP~
			ButtonText:~UVWMAPADD_BUTTONTEXT~ 
            
(
	on execute do AddMod UVW_Mapping_Add
	on isEnabled return mcrUtils.ValidMod UVW_Mapping_Add
)

macroScript UvwmapClear
            category:~UVWMAPCLEAR_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~UVWMAPCLEAR_TOOLTIP~
			ButtonText:~UVWMAPCLEAR_BUTTONTEXT~ 
            
(
	on execute do AddMod UVW_Mapping_Clear
	on isEnabled return mcrUtils.ValidMod UVW_Mapping_Clear
)

macroScript WMapscaler
            category:~WMAPSCALER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~WMAPSCALER_TOOLTIP~
			ButtonText:~WMAPSCALER_BUTTONTEXT~ 
            
(
	on execute do AddMod MapScaler
	on isEnabled return mcrUtils.ValidMod MapScaler
)

macroScript MapScaler 
            category:~MAPSCALER_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~MAPSCALER_TOOLTIP~
			ButtonText:~MAPSCALER_BUTTONTEXT~ 
(
	on execute do addModifier $ (MapScaler ())
        on isEnabled return mcrUtils.ValidMod MapScaler
)


-- new modifier for Autodesk VIZ 2005
macroScript RenderableSPline
            category:~RENDERABLESPLINE_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~RENDERABLESPLINE_TOOLTIP~ 
			ButtonText:~RENDERABLESPLINE_BUTTONTEXT~
            --Icon:#("Material_Modifiers",6)
(
	on execute do AddMod Renderable_Spline
	on isEnabled return mcrUtils.ValidMod Renderable_Spline
)


-- pfbreton, mai 29 12 2003
-- this function is similar to the CameraCorrection_Quad available in the Macros_Cameras.mcr
-- the only difference is in the Visibility flags for Quads
-- the reason for this is to have the menu item visible from the pulldown | Modifier menu
-- AND control the visibility in the quads.  Doing this requires a duplicated definition of the scripts

macroScript CameraCorrection 
            category:~CAMERACORRECTION_CATEGORY~ 
            internalCategory:"Modifiers" 
            tooltip:~CAMERACORRECTION_TOOLTIP~ 
	    ButtonText:~CAMERACORRECTION_BUTTONTEXT~
(
    on execute do addMod CamPerspCorrect
    on isEnabled return (Filters.Is_Camera $)
)

-- moved attribute holder modifier into stdplugs/stdscripts for max r7
macroScript Attribute_Holder 
			category:~ATTRIBUTE_HOLDER_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~ATTRIBUTE_HOLDER_TOOLTIP~
			ButtonText:~ATTRIBUTE_HOLDER_BUTTONTEXT~ 
(
	on execute do AddMod EmptyModifier 
	on isEnabled return mcrUtils.ValidMod EmptyModifier 
)


-- pfbreton: adding new modifiers for 3ds max 7
macroScript ProjectionMod 
			category:~PROJECTIONMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~PROJECTIONMOD_TOOLTIP~
			ButtonText:~PROJECTIONMOD_BUTTONTEXT~ 
(
	on execute do AddMod ProjectionMod
	on isEnabled return mcrUtils.ValidMod ProjectionMod
)


macroScript Skin_MorphMod 
			category:~SKIN_MORPHMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~SKIN_MORPHMOD_TOOLTIP~
			ButtonText:~SKIN_MORPHMOD_BUTTONTEXT~ 
(
	on execute do AddMod Skin_Morph
	on isEnabled return mcrUtils.ValidMod Skin_Morph
)

macroScript Skin_WrapMod 
			category:~SKIN_WRAPMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~SKIN_WRAPMOD_TOOLTIP~
			ButtonText:~SKIN_WRAPMOD_BUTTONTEXT~ 
(
	on execute do AddMod Skin_Wrap
	on isEnabled return mcrUtils.ValidMod Skin_Wrap
)
macroScript Skin_WrapPatchMod 
			category:~SKIN_WRAPPATCHMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~SKIN_WRAPPATCHMOD_TOOLTIP~
			ButtonText:~SKIN_WRAPPATCHMOD_BUTTONTEXT~ 
(
	on execute do AddMod Skin_Wrap_Patch
	on isEnabled return mcrUtils.ValidMod Skin_Wrap_Patch
)

macroScript TurboSmoothMod 
			category:~TURBOSMOOTHMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~TURBOSMOOTHMOD_TOOLTIP~
			ButtonText:~TURBOSMOOTHMOD_BUTTONTEXT~ 
(
	on execute do AddMod TurboSmooth
	on isEnabled return mcrUtils.ValidMod TurboSmooth
)

macroScript EditPolyMod 
			category:~EDITPOLYMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~EDITPOLYMOD_TOOLTIP~
			ButtonText:~EDITPOLYMOD_BUTTONTEXT~ 
(
	on execute do AddMod EditPolyMod
	on isEnabled return mcrUtils.ValidMod EditPolyMod
)

macroScript PhysiqueMod
			category:~PHYSIQUEMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~PHYSIQUEMOD_TOOLTIP~
			ButtonText:~PHYSIQUEMOD_BUTTONTEXT~ 
(
	on execute do AddMod Physique
	on isEnabled return mcrUtils.ValidMod Physique
)

macroScript SubstituteMod
			category:~SUBSTITUTEMOD_CATEGORY~ 
			internalCategory:"Modifiers" 
			tooltip:~SUBSTITUTEMOD_TOOLTIP~
			ButtonText:~SUBSTITUTEMOD_BUTTONTEXT~ 
(
	on execute do AddMod SubstituteMod
	on isEnabled return mcrUtils.ValidMod SubstituteMod
)

macroScript SweepMod
            category:~SWEEPMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~SWEEPMOD_BUTTONTEXT~
            tooltip:~SWEEPMOD_TOOLTIP~ 

(
	on execute do AddMod Sweep
	on isEnabled return mcrUtils.ValidMod Sweep
)

macroScript ClothMod
            category:~CLOTHMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~CLOTHMOD_BUTTONTEXT~
            tooltip:~CLOTHMOD_TOOLTIP~ 

(
	on execute do AddMod Cloth
	on isEnabled return mcrUtils.ValidMod Cloth
)

macroScript Garment_MakerMod
            category:~GARMENT_MAKERMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~GARMENT_MAKERMOD_BUTTONTEXT~
            tooltip:~GARMENT_MAKERMOD_TOOLTIP~ 

(
	on execute do AddMod Garment_Maker
	on isEnabled return mcrUtils.ValidMod Garment_Maker
)

macroScript HairMod
            category:~HAIRMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
			ButtonText:~HAIRMOD_BUTTONTEXT~
            tooltip:~HAIRMOD_TOOLTIP~ 

(
	on execute do AddMod HairMod
	on isEnabled return mcrUtils.ValidMod HairMod
)

macroScript ProOptimizerMod
            category:~PROOPTIMIZERMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~PROOPTIMIZERMOD_BUTTONTEXT~
            tooltip:~PROOPTIMIZERMOD_TOOLTIP~ 

(
	on execute do AddMod ProOptimizer
	on isEnabled return mcrUtils.ValidMod ProOptimizer
)

macroScript QuadifyMeshMod
            category:~QUADIFYMESHMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~QUADIFYMESHMOD_BUTTONTEXT~
            tooltip:~QUADIFYMESHMOD_TOOLTIP~ 

(
	on execute do AddMod Quadify_Mesh
	on isEnabled return mcrUtils.ValidMod Quadify_Mesh
)

macroScript WelderMod
            category:~WELDERMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~WELDERMOD_BUTTONTEXT~
            tooltip:~WELDERMOD_TOOLTIP~ 

(
	on execute do AddMod Welder
	on isEnabled return mcrUtils.ValidMod Welder
)

macroScript ChamferMod
            category:~CHAMFERMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~CHAMFERMOD_BUTTONTEXT~
			tooltip:~CHAMFERMOD_TOOLTIP~ 
            Icon:#("Standard_Modifiers",38)
(
	on execute do AddMod ChamferMod
	on isEnabled return mcrUtils.ValidMod ChamferMod
)

macroScript OpenSubdivMod
            category:~OPENSUBDIVMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~OPENSUBDIVMOD_BUTTONTEXT~
			tooltip:~OPENSUBDIVMOD_TOOLTIP~ 
            Icon:#("Standard_Modifiers",39)
(
	on execute do AddMod OpenSubdivMod
	on isEnabled return mcrUtils.ValidMod OpenSubdivMod
)

macroScript CreaseSetMod
            category:~CREASESETMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~CREASESETMOD_BUTTONTEXT~
			tooltip:~CREASESETMOD_TOOLTIP~ 
            Icon:#("Standard_Modifiers",40)
(
	on execute do AddMod CreaseSetMod
	on isEnabled return mcrUtils.ValidMod CreaseSetMod
)

macroScript CreaseMod
            category:~CREASEMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~CREASEMOD_BUTTONTEXT~
			tooltip:~CREASEMOD_TOOLTIP~ 
            Icon:#("Standard_Modifiers",41)
(
	on execute do AddMod CreaseMod
	on isEnabled return mcrUtils.ValidMod CreaseMod
)

macroScript Data_ChannelMod
            category:~DATACHANNELMOD_CATEGORY~ 
            internalCategory:"Modifiers" 
            ButtonText:~DATACHANNELMOD_BUTTONTEXT~
			tooltip:~DATACHANNELMOD_TOOLTIP~ 
            Icon:#("Standard_Modifiers",42)
(
	on execute do AddMod DataChannelModifier
	on isEnabled return mcrUtils.ValidMod DataChannelModifier
)

